
<?php $__env->startSection('page_title', __('Edit Chat Assistant')); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('Modules/MediaManager/Resources/assets/css/media-manager.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Main content -->
<div class="col-sm-12">
    <div class="card">
        <div class="card-header">
            <h5>
                <a class="pe-1" href="<?php echo e(route('admin.chat.assistant.list')); ?>"><?php echo e(__('Chat Assistants')); ?></a>>>
                <span class="ps-1"><?php echo e(__('Edit :x', ['x' => __('Chat Assistant')])); ?></span>
            </h5>
        </div>

        <div class="card-body px-3" id="no_shadow_on_card">
            <div class="col-sm-12 m-t-20 form-tabs">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link font-bold active text-uppercase" id="home-tab" data-bs-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true"><?php echo e(__(':x Information', ['x' => __('Chat Assistant')])); ?></a>
                    </li>
                </ul>

                <div class="card-block table-border-style tab-content">
                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <div class="col-sm-12">
                            <form action="<?php echo e(route('admin.chat.assistant.edit', [ 'id' => $chatBot->id])); ?>" method="post" class="form-horizontal" enctype="multipart/form-data" id="form" onsubmit="return formValidation()" novalidate>
                                <input type="hidden" value="<?php echo e(csrf_token()); ?>" name="_token" id="token">
                                <div class="form-group row">
                                    <label for="first_name" class="col-sm-2 require col-form-label pr-0"><?php echo e(__('Category')); ?>

                                    </label>
                                    <div class="col-sm-10">
                                        <select class="form-control sl_common_bx select2-hide-search" id="chat_category_id" name="chat_category_id">
                                            <option value=""><?php echo e(__('Select One')); ?></option>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>" <?php echo e($category->id == $chatBot->chat_category_id ? 'selected' : ''); ?>>
                                                    <?php echo e($category->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="name" class="col-sm-2 col-form-label require"><?php echo e(__('Name')); ?></label>
                                    <div class="col-sm-10">
                                        <input type="text" placeholder="<?php echo e(__('Name')); ?>" class="form-control inputFieldDesign" id="name" name="name" value="<?php echo e($chatBot->name); ?>" maxlength="191" oninvalid="this.setCustomValidity(<?php echo e(__('This field is required.')); ?>)" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-2 control-label"><?php echo e(__('Featured Image')); ?></label>
                                    <input type="hidden" name="code" value="<?php echo e($chatBot->code); ?>" id="code">
                                    <div class="col-sm-10">
                                        <div class="custom-file has-media-manager has-thumbnail" data-val="single"
                                            id="image-status">
                                            <input class="form-control up-images attachment d-none" name="attachment"
                                                id="validatedCustomFile" accept="image/*">
                                            <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                for="validatedCustomFile"><?php echo e(__('Upload image')); ?></label>
                                        </div>
                                        <div class="d-flex" id="bot-image">
                                            <!-- img will be shown here -->

                                            <div class="d-flex flex-wrap mt-2">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($chatBot->objectFile->file_id)): ?>
                                                    <div
                                                        class="position-relative border boder-1 p-1 me-2 rounded mt-2">
                                                        <input type="hidden" name="file_id[]"
                                                            value="<?php echo e(optional($chatBot->objectFile)->file_id); ?>">
                                                        <div
                                                            class="position-absolute rounded-circle text-center img-remove-icon">
                                                            <i class="fa fa-times"></i>
                                                        </div>

                                                        <img class="upl-img" class="p-1"
                                                            src="<?php echo e($chatBot->fileUrl()); ?>">
                                                    </div>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="description" class="col-sm-2 col-form-label require"><?php echo e(__('Message')); ?></label>
                                    <div class="col-sm-10">
                                        <textarea placeholder="<?php echo e(__('Message')); ?>" id="message" class="form-control" name="message" oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')" required><?php echo e($chatBot->message); ?></textarea>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="first_name"
                                        class="col-sm-2 col-form-label require pr-0"><?php echo e(__('Role')); ?>

                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" placeholder="<?php echo e(__('Role')); ?>" class="form-control inputFieldDesign" id="role" name="role" value="<?php echo e($chatBot->role); ?>" maxlength="191" oninvalid="this.setCustomValidity(<?php echo e(__('This field is required.')); ?>)" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="description" class="col-sm-2 col-form-label require"><?php echo e(__('Prompt')); ?></label>
                                    <div class="col-sm-10">
                                        <textarea placeholder="<?php echo e(__('Prompt')); ?>" id="promt" class="form-control" name="promt" oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')" required><?php echo e($chatBot->promt); ?></textarea>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label for="Status" class="col-md-2 col-3 col-form-label require"><?php echo e(__('Status')); ?></label>
                                    <div class="col-sm-10">
                                        <select name="status" class="form-control select2-hide-search" id="status">
                                            <option value=""><?php echo e(__('Select One')); ?> </option>
                                            <option value="Active" <?php echo e($chatBot->status === 'Active' ? 'selected' : ''); ?>><?php echo e(__('Active')); ?> </option>
                                            <option value="Inactive" <?php echo e($chatBot->status === 'Inactive' ? 'selected' : ''); ?> ><?php echo e(__('Inactive')); ?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row mt-1 mb-1">
                                    <label for="Status" class="col-md-2 col-3 col-form-label require"><?php echo e(__('Is Default')); ?></label>
                                    <div class="col-md-10 col-9 s margin-top-6">
                                        <div class="switch switch-bg d-inline m-r-10">
                                            <input type="hidden" name="is_default" value="0">
                                            <input class="status" type="checkbox" value="1" name="is_default"
                                                id="is_private" <?php echo e($chatBot->is_default === 1 ? 'checked' : ''); ?>>
                                            <label for="is_private" class="cr"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="d-flex justify-items-start mt-4 flex-wrap">
                                        <a href="<?php echo e(route('admin.chat.assistant.list')); ?>" class="btn custom-btn-cancel all-cancel-btn"><?php echo e(__('Cancel')); ?></a>
                                        <button class="btn custom-btn-submit" type="submit" id="btnUpdate">
                                            <i class="comment_spinner spinner fa fa-spinner fa-spin custom-btn-small display_none"></i>
                                            <span id="spinnerText"><?php echo e(__('Update')); ?></span>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <?php echo $__env->make('mediamanager::image.modal_image', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    'use strict';
    var currentUrl = "<?php echo url()->full(); ?>";
    var loginNeeded = "<?php echo session('loginRequired') ? 1 : 0; ?>";
    var slug = false;
</script>
<script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
<script src="<?php echo e(asset('Modules/OpenAI/Resources/assets/js/admin/chat-bot.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/consuadmin/public_html/Modules/OpenAI/Resources/views/admin/chat-assistant/edit.blade.php ENDPATH**/ ?>