<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('Modules/MediaManager/Resources/assets/css/style.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('Modules/MediaManager/Resources/assets/css/media-manager.min.css')); ?>">
<?php $__env->stopSection(); ?>
<div class="modal fade all-image-modal" id="exampleModalCenter"
    tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" data-keyboard="false"
    data-backdrop="static">
    <div class="img-preview-modal modal-dialog modal-width modal-dialog-centered"
        role="document">
        <div class="modal-content">
            <div class="modal-header image-modal img-preview-modal-header">
                <div class="uploaded-file">
                    <p id="select-file" class="modal-title-color modal-title me-3 p-2" id="exampleModalLongTitle">
                        <?php echo e(__('Select File')); ?></p>
                    <p id="upload-new" class="modal-title p-2" id="exampleModalLongTitle"><?php echo e(__('Upload New')); ?></p>
                </div>
                <button type="button" class="btn-close" aria-label="Close" data-bs-dismiss="modal"></button>
                <?php
                    $acceptedFiles = getFileExtensions();
                    $Files = implode(',', $acceptedFiles);
                    $array = explode(',', '.' . implode(',.', $acceptedFiles));
                    $acceptedFilesNew = implode(',', $array);
                ?>

            </div>
            <div class="modal-body position-relative img-preview-modal-body image-modal-body">
                <div id="upload-card-header" class="card-header image-card-header">
                    <div class="select-dropdown-section">
                        <div class="dropdown">
                            <select class="form-select h-40 form-control-xs sort-option-modal">
                                <option <?php echo e(request()->sort_value == 'newest' ? ' selected' : ''); ?> value="newest">
                                    <?php echo e(__('Sort by newest')); ?></option>
                                <option <?php echo e(request()->sort_value == 'oldest' ? ' selected' : ''); ?> value="oldest">
                                    <?php echo e(__('Sort by oldest')); ?></option>
                                <option <?php echo e(request()->sort_value == 'largest' ? ' selected' : ''); ?> value="largest">
                                    <?php echo e(__('Sort by largest')); ?></option>
                                <option <?php echo e(request()->sort_value == 'smallest' ? ' selected' : ''); ?> value="smallest">
                                    <?php echo e(__('Sort by smallest')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="position-static search-section">
                        <input type="text" id="search-input" class="form-control form-control-xs search-image upload-search-image" placeholder="<?php echo e(__('Search your files')); ?>">
                        <i class="search-icon"><span></span></i>
                    </div>
                </div>
                <div class="h-100">
                    <div id="select-items">
                        <?php
                        $files = App\Models\File::getAllFiles();
                        ?>
                        <div id="image-card-container" class="modal-img-container mx-3 media-manager-child-card gap-4">
                            <?php echo $__env->make('mediamanager::image.child_paginate', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                    <div id="browse-file">
                        <div class="form-group" id="file-type">
                            <label class="col-md-8 control-label"></label>
                            <div class="col-md-8 upload-note ps-4">
                                <span class="badge badge-danger"><?php echo e(__('Note')); ?>!</span>
                                <?php echo e(__('Allowed File Extensions:')); ?> <span
                                    id="accepted-type"><?php echo e($Files); ?></span>
                            </div>
                        </div>
                        <div class="uploaded-file-design">
                            <div class="card-block upload-file-card p-0 h-100">
                                <form action="<?php echo e(route('mediaManager.store')); ?>" class="dropzone form-border-design">
                                    <?php echo csrf_field(); ?>
                                    <div class="fallback">
                                        <input name="file" type="file" multiple />
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="loader" class="loader-section">
                <div class="loader-background-design">
                </div>
                <div id="loader-section" class="loader"></div>
            </div>

            <div class="modal-footer justify-content-between img-preview-modal-footer">
                <div class="d-flex align-items-center file-number-show flex-grow-1 overflow-hidden">
                    <div>
                        <div id="file-count" class="me-3">
                            <p> <span id="add-file-count">0</span> <?php echo e(__('Files selected')); ?></p>
                        </div>
                        <div id="clear-items" class="d-none">
                            <p class="border-0 text-danger m-0 text-nowrap"><?php echo e(__('Clear all')); ?></p>
                        </div>
                    </div>
                    <div class="image-modal-pagination" id="modal-pagination-container">
                        <?php echo $files->links('partials.custom-paginator'); ?>

                    </div>
                </div>
                <div class="modal-button-section">
                    <button type="button" id="clear-item"
                        class="image-modal-clear-button btn btn-warning"><?php echo e(__('Clear')); ?></button>
                    <button type="button" class="image-modal-add-button btn btn-file-add"><?php echo e(__('Add')); ?></button>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo e(asset('Modules/MediaManager/Resources/assets/js/media-manager.min.js')); ?>"></script>
<script type="text/javascript">
    'use strict';
    var maxFileSize = "<?php echo e(preference('file_size')); ?>";
    var acceptedFiles = "<?php echo e($acceptedFilesNew); ?>";
</script>
<script src="<?php echo e(asset('public/datta-able/plugins/sweetalert/js/sweetalert.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/dist/plugins/dropzone/dropzone.min.js')); ?>"></script>
<?php /**PATH /home/consuadmin/public_html/Modules/MediaManager/Resources/views/image/modal_image.blade.php ENDPATH**/ ?>