<?php
    $component = isset($component) ? $component : null;
?>

<link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/mini-color/css/jquery.minicolors.min.css')); ?>">

<div class="card dd-content <?php echo e($editorClosed ?? 'card-hide'); ?>">
    <div class="card-body">
        <form action="<?php echo e(route('builder.update', ['id' => '__id'])); ?>" data-type="component" method="post"
            class="component_form form-parent silent-form" novalidate>
            <?php echo csrf_field(); ?>
            <?php echo $__env->make('cms::hidden_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->make('cms::edit.sub.background', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Heading')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control section_name inputFieldDesign" name="heading" value="<?php echo e($component ? $component->heading : ''); ?>">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label">
                    <dt><?php echo e(__('Body')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <textarea class="form-control crequired" name="body" required> <?php echo e($component ? trim($component->body) : ''); ?></textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-md-3 control-label"><?php echo e(__('Brands')); ?></label>
                <div class="col-md-8">
                    <div class="accordion brand-accordion <?php echo e($accordId = uniqid('accord_')); ?>" id="accordionExample">
                        <?php
                            $brands = $component && is_array($component->brand) ? $component->brand : [];
                            $totalBrands = count($brands);
                        ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                            <?php $brand = miniCollection($brand); ?>

                            <div class="card cta-card mb-3">
                                <div class="card-header p-2" id="headingOne">
                                    <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                        data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                        aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                        <div><?php echo e(__('Brand\'s Logo')); ?></div>
                                        <span class="b-icon">
                                            <i class="feather icon-chevron-down collapse-status"></i>
                                            <span class="accordion-action-group">
                                                <?php if($loop->last): ?>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($totalBrands > 1): ?>
                                                        <span class="accordion-row-action remove-row-btn"
                                                            data-parent="<?php echo e($accordId); ?>"
                                                            data-index="<?php echo e($loop->index + 1); ?>"><i
                                                                class="feather icon-minus"></i></span>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    <span class="accordion-row-action add-row-btn"
                                                        data-parent="<?php echo e($accordId); ?>"
                                                        data-index="<?php echo e($loop->index + 1); ?>"><i
                                                            class="feather icon-plus"></i></span>
                                                <?php else: ?>
                                                    <span class="accordion-row-action remove-row-btn"
                                                        data-index="<?php echo e($loop->index + 1); ?>"
                                                        data-parent="<?php echo e($accordId); ?>"><i
                                                            class="feather icon-minus"></i></span>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                                <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class"
                                    aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <div class="form-group row">
                                                <label class="col-sm-12 control-label"><?php echo e(__('Light Mode')); ?></label>
                                                <?php $rand = uniqid(); ?>
                                                <div class="col-md-12">
                                                    <div class="custom-file media-manager"
                                                        data-name="brand[<?php echo e($loop->index); ?>][light_logo]"
                                                        data-val="single" id="image-status">
                                                        <input class="custom-file-input form-control d-none"
                                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                                    </div>
                                                    <div class="preview-image">
                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($brand['light_logo']): ?>
                                                            <div class="d-flex flex-wrap mt-2">
                                                                <div
                                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                                    <div
                                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                                        <i class="fa fa-times"></i>
                                                                    </div>
                                                                    <img class="upl-img" class="p-1"
                                                                        src="<?php echo e(pathToUrl($brand['light_logo'])); ?>"
                                                                        alt="<?php echo e(__('Image')); ?>">
                                                                    <input type="hidden"
                                                                        name="brand[<?php echo e($loop->index); ?>][light_logo]"
                                                                        id="validatedCustomFile"
                                                                        value="<?php echo e($brand['light_logo']); ?>">
                                                                </div>
                                                            </div>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group row">
                                                <label class="col-sm-12 control-label"><?php echo e(__('Dark Mode')); ?></label>

                                                <?php $rand = uniqid(); ?>
                                                <div class="col-md-12">
                                                    <div class="custom-file media-manager"
                                                        data-name="brand[<?php echo e($loop->index); ?>][dark_logo]"
                                                        data-val="single" id="image-status">
                                                        <input class="custom-file-input form-control d-none"
                                                            id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                                        <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                            for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                                    </div>
                                                    <div class="preview-image">
                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($brand['dark_logo']): ?>
                                                            <div class="d-flex flex-wrap mt-2">
                                                                <div
                                                                    class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                                                    <div
                                                                        class="position-absolute rounded-circle text-center img-remove-icon">
                                                                        <i class="fa fa-times"></i>
                                                                    </div>
                                                                    <img class="upl-img" class="p-1"
                                                                        src="<?php echo e(pathToUrl($brand['dark_logo'])); ?>"
                                                                        alt="<?php echo e(__('Image')); ?>">
                                                                    <input type="hidden"
                                                                        name="brand[<?php echo e($loop->index); ?>][dark_logo]"
                                                                        id="validatedCustomFile"
                                                                        value="<?php echo e($brand['dark_logo']); ?>">
                                                                </div>
                                                            </div>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="card cta-card mb-3">
                                <div class="card-header p-2" id="headingOne">
                                    <div class="mb-0 ac-switch collapsed d-flex closed justify-content-between align-items-center w-full curson-pointer"
                                        data-bs-toggle="collapse" data-bs-target="#<?php echo e($ac = 'ac' . randomString()); ?>"
                                        aria-expanded="true" aria-controls="<?php echo e($ac); ?>">
                                        <div><?php echo e(__('Brand\'s Logo')); ?></div>
                                        <span class="b-icon">
                                            <i class="feather icon-chevron-down collapse-status"></i>
                                            <span class="accordion-action-group">
                                                <span class="accordion-row-action add-row-btn"
                                                    data-parent="<?php echo e($accordId); ?>" data-index="1"><i
                                                        class="feather icon-plus"></i></span>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                                <div id="<?php echo e($ac); ?>" class="card-body collapse parent-class"
                                    aria-labelledby="headingOne" data-parent=".<?php echo e($accordId); ?>">
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <div class="form-group row">
                                                <div class="col-md-6">
                                                    <div class="form-group row">
                                                        <label class="col-sm-12 control-label"><?php echo e(__('Light Logo')); ?></label>
        
                                                        <?php $rand = uniqid(); ?>
                                                        <div class="col-md-12">
                                                            <div class="custom-file media-manager"
                                                                data-name="brand[0][light_logo]" data-val="single"
                                                                id="image-status">
                                                                <input class="custom-file-input form-control d-none"
                                                                    id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                                                <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                                    for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                                            </div>
                                                            <div class="preview-image"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group row">
                                                        <label class="col-sm-12 control-label"><?php echo e(__('Dark Logo')); ?></label>
                                                        <?php $rand = uniqid(); ?>

                                                        <div class="col-md-12">
                                                            <div class="custom-file media-manager"
                                                                data-name="brand[0][dark_logo]" data-val="single"
                                                                id="image-status">
                                                                <input class="custom-file-input form-control d-none"
                                                                    id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                                                <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                                                    for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                                                            </div>
                                                            <div class="preview-image"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <?php echo $__env->make('cms::edit.sub.text-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('cms::edit.sub.appearance', ['fields' => ['padding-vertical']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo do_action('adsense_form',  $component); ?>

            <?php echo $__env->make('cms::pieces.submit-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </form>
    </div>
</div>

<!-- form-picker-custom Js -->
<script src="<?php echo e(asset('public/datta-able/js/pages/form-picker-custom.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/datta-able/plugins/mini-color/js/jquery.minicolors.min.js')); ?>"></script><?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/edit/brands-template-v1.blade.php ENDPATH**/ ?>