
<?php $__env->startSection('page_title', __('View :x', ['x' => __('Import')])); ?>
<?php $__env->startSection('content'); ?>
<div class="col-sm-12 list-container" id="item-list-container">
    <div class="card">
        <div class="card-header d-md-flex justify-content-between align-items-center">
            <h5><?php echo e(__('Actors Import')); ?></h5>
        </div>
        <div class="col-sm-12">
            <div class="card-block pt-2">
                <button class="btn btn-outline-primary custom-btn-smal d-inline-flex rtl:gap-2 align-items-center" id="fileRequest"><i
                        class="fa fa-download"></i><?php echo e(__('Download Sample')); ?></button>
                <hr>
                <p><?php echo e(__('Your CSV data should be in the format below. The first line of your CSV file should be the column headers as in the table example. Also make sure that your file is UTF-8 to avoid unnecessary encoding problems.')); ?>

                </p>

                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Name')); ?><span class="text-danger">*</span></th>
                                <th><?php echo e(__('Voice')); ?><span class="text-danger">*</span></th>
                                <th><?php echo e(__('Gender')); ?><span class="text-danger">*</span></th>
                                <th><?php echo e(__('Language')); ?><span class="text-danger">*</span></th>
                                <th class="w-auto"><?php echo e(__('Audio')); ?><span class="text-danger">*</span></th>
                                <th><?php echo e(__('Status')); ?><span class="text-danger">*</span></th>
                                <th><?php echo e(__('Image')); ?><span class="text-danger">*</span></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Ethan Parker</td>
                                <td>alloy</td>
                                <td>Male</td>
                                <td>en</td>
                                <td>C:\Users\user\Desktop\audio.mp3</td>
                                <td>Active</td>
                                <td>C:\Users\user\Desktop\ethan.jpeg</td>
                            </tr>
                            <tr>
                                <td>Caleb Mitchell</td>
                                <td>echo</td>
                                <td>Male</td>
                                <td>en</td>
                                <td>C:\Users\user\Desktop\caleb.mp3</td>
                                <td>Active</td>
                                <td>C:\Users\user\Desktop\mitchel.jpeg</td>
                            </tr>
                        </tbody>
                    </table>
                    <span class="badge badge-info"><?php echo e(__('Note')); ?></span> <small
                        class="text-info"><?php echo e(__('Required field is mandatory. If any provider is missing the language field, please ensure it is added in ISO 639-1 format, such as en for English.')); ?></small>
                </div><br>

                <form action="#" method="post" id="myform1" class="form-horizontal"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <div class="row">
                            <label class="col-md-2 control-label pt-1"><?php echo e(__('Select Provider')); ?>

                                <span class="text-danger">*</span>
                            </label>
                            <div class="custom-file position-relative col-md-8 p-0">
                                <div class="custom-file">
                                    <select class="form-control sl_common_bx"
                                    id="provider" name="provider" required
                                    oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($provider['display_name']); ?>"><?php echo e($provider['display_name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                            <label class="col-md-2 control-label pt-1"><?php echo e(__('Choose CSV File')); ?>

                                <span class="text-danger">*</span>
                            </label>
                            <div class="custom-file position-relative col-md-8">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" name="file"
                                        id="validatedCustomFile">
                                    <label class="custom-file-label overflow_hidden d-flex align-items-center"
                                        for="validatedCustomFile"><?php echo e(__('Upload csv...')); ?></label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row d-none" id="api_url">
                        <label class="col-md-2 control-label note"></label>
                        
                        <div class="col-md-8">
                            <div id="note_txt_1">
                                <span class="badge badge-info"><?php echo e(__('API Url')); ?></span>
                                <small class="text-info url-note">
                                    <a href="javascript:void(0)" target="_blank"></a>
                                </small>
                            </div>
                    
                            <div id="note_txt_2">
                                <span class="badge badge-info"><?php echo e(__('Note')); ?></span>
                                <small class="text-info important-note"></small>
                            </div>
                        </div>
                    </div>
                    

                    <!-- /.box-body -->
                    <div class="col-sm-8 px-0 mt-3">
                        <button class="btn custom-btn-submit" type="submit"
                            id="submit"><?php echo e(__('Import')); ?></button>
                    </div>
                    <!-- /.box-footer -->
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('Modules/OpenAI/Resources/assets/js/admin/actor-import.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/consuadmin/public_html/Modules/OpenAI/Resources/views/admin/import/actor.blade.php ENDPATH**/ ?>