<?php
    $component = isset($component) ? $component : null;
    $rand = uniqid();
?>

<link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/mini-color/css/jquery.minicolors.min.css')); ?>">

<div class="card dd-content <?php echo e($editorClosed ?? 'card-hide'); ?>">
    <div class="card-body">
        <form action="<?php echo e(route('builder.update', ['id' => '__id'])); ?>" novalidate data-type="component" method="post"
            class="component_form form-parent silent-form">
            <?php echo csrf_field(); ?>
            <?php echo $__env->make('cms::hidden_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            
            <?php echo $__env->make('cms::edit.sub.background', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            
            <div class="form-group row">
                <label class="col-sm-3 control-label ">
                    <dt><?php echo e(__('Heading')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control inputFieldDesign"
                    value="<?php echo e($component ? $component->heading : ''); ?>" name="heading">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-3 control-label ">
                    <dt><?php echo e(__('Body')); ?></dt>
                </label>
                <div class="col-sm-8">
                    <input type="text" class="form-control inputFieldDesign"
                            value="<?php echo e($component ? $component->body : ''); ?>" name="body">
                </div>
            </div>

            <div class="form-group row">
                <div class="col-sm-3">
                    <label class="control-label text-left">
                        <dt><?php echo e(__('Image')); ?></dt>
                    </label>
                </div>
                <div class="col-sm-8">
                    <div class="form-group row form-parent parent-class">
                        <div class="col-sm-12">
                            <div class="custom-file media-manager" data-name="image" data-val="single"
                                id="image-status">
                                <input class="custom-file-input form-control d-none inputFieldDesign" name="image"
                                    id="validatedCustomFile<?php echo e($rand); ?>" maxlength="50" accept="image/*">
                                <label class="custom-file-label overflow_hidden position-relative d-flex align-items-center"
                                    for="validatedCustomFile<?php echo e($rand); ?>"><?php echo e(__('Upload image')); ?></label>
                            </div>
                            <div class="preview-image">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($component && $component->image): ?>
                                    <div class="d-flex flex-wrap mt-2">
                                        <div
                                            class="position-relative border boder-1 media-box p-1 mr-2 rounded mt-2">
                                            <div
                                                class="position-absolute rounded-circle text-center img-remove-icon">
                                                <i class="fa fa-times"></i>
                                            </div>
                                            <img class="upl-img" class="p-1"
                                                src="<?php echo e(pathToUrl($component->image)); ?>"
                                                alt="<?php echo e(__('Image')); ?>">
                                            <input type="hidden" name="image"
                                                value="<?php echo e($component->image); ?>">
                                        </div>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php echo $__env->make('cms::edit.sub.text-color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('First Button')); ?></dt>
                        </label>
                        <input type="hidden" name="first_button" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="first_button"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->first_button == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Name')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control inputFieldDesign" maxlength="30"
                                        value="<?php echo e($component ? $component->btn_name1 : ''); ?>" name="btn_name1">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Link')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control inputFieldDesign"
                                        value="<?php echo e($component ? $component->btn_link1 : ''); ?>" name="btn_link1">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Light)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_light1"
                                            value="<?php echo e($component ? $component->btn_color_light1 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Dark)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_dark1"
                                            value="<?php echo e($component ? $component->btn_color_dark1 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_light1"
                                            value="<?php echo e($component ? $component->btn_text_color_light1 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_dark1"
                                            value="<?php echo e($component ? $component->btn_text_color_dark1 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <div class="form-group row">
                        <label class="control-label text-left">
                            <dt><?php echo e(__('Second Button')); ?></dt>
                        </label>
                        <input type="hidden" name="second_button" value="0">
                        <div class="col-md-12">
                            <div class="switch switch-warning d-inline m-r-10">
                                <input type="checkbox" name="second_button"
                                    id="<?php echo e($sw = uniqid('sw_')); ?>" value="1"
                                    <?php echo e($component && $component->second_button == 1 ? 'checked' : ''); ?>>
                                <label for="<?php echo e($sw); ?>" class="cr"></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="row">
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Name')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control inputFieldDesign" maxlength="30"
                                        value="<?php echo e($component ? $component->btn_name2 : ''); ?>" name="btn_name2">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-6">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Link')); ?></label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control inputFieldDesign"
                                        value="<?php echo e($component ? $component->btn_link2 : ''); ?>" name="btn_link2">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Light)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_light2"
                                            value="<?php echo e($component ? $component->btn_color_light2 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Button Color (Dark)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_color_dark2"
                                            value="<?php echo e($component ? $component->btn_color_dark2 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Light Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_light2"
                                            value="<?php echo e($component ? $component->btn_text_color_light2 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 col-md-3">
                            <div class="form-group">
                                <label class="col-sm-12 control-label"><?php echo e(__('Text Color (Dark Mode)')); ?></label>
                                <div class="col-sm-12">
                                    <div>
                                        <input type="text"
                                            class="form-control demo layout-primary-color inputFieldDesign" data-control="hue" name="btn_text_color_dark2"
                                            value="<?php echo e($component ? $component->btn_text_color_dark2 : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php echo $__env->make('cms::edit.sub.appearance', ['fields' => ['margin']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo do_action('adsense_form',  $component); ?>
            
            <?php echo $__env->make('cms::pieces.submit-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </form>
    </div>
</div>


<!-- form-picker-custom Js -->
<script src="<?php echo e(asset('public/datta-able/js/pages/form-picker-custom.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/datta-able/plugins/mini-color/js/jquery.minicolors.min.js')); ?>"></script><?php /**PATH /home/consuadmin/public_html/Modules/CMS/Resources/views/edit/footer-banner-template-v1.blade.php ENDPATH**/ ?>