@extends('layouts.user_master')
@section('content')
<div class="w-[68.9%] 5xl:w-[85.9%] md:w-4/5 flex flex-col flex-1 border-l dark:border-[#474746] border-color-DF">
    <div class="xl:flex justify-between relative xl:h-screen sidebar-scrollbar subscription-main">
        <div class="bg-[#F6F3F2] dark:bg-[#3A3A39] xl:w-[401px] 5xl:w-[474px] flex flex-col gap-4 p-6 sidebar-scrollbar overflow-auto pt-[74px] sidebar-scrollbar xl:overflow-auto xl:h-screen">
            @if (count($contents) > 0)
                @foreach ($contents as $content)
                    <div class="border border-design-3 border-color-DF dark:border-[#474746] rounded-xl cursor-pointer bg-white dark:bg-[#474746] saved-content save-content-{{ $content->id }}"
                        id="{{ $content->id }}">
                        <div class="p-4">
                            <p class="text-16 font-semibold text-color-2C dark:text-white">
                                {{ optional($content->useCase)->slug }}</p>
                            <p class="text-14 font-light text-color-2C dark:text-white pt-2 pb-1 break-all">
                                {{ trimWords($content->promt, 120) }}</p>
                            <p class="text-14 font-light text-color-2C dark:text-white break-all">{!! trimWords($content->content, 60) !!}</p>
                            <p class="leading-[18px] text-xs font-semibold text-color-2C dark:text-color-89 pt-4 break-all">
                                {{ $content->created_at->diffForHumans() }}</p>
                        </div>
                    </div>
                @endforeach
            @else
            <div class="mt-10">
                <svg class="mx-auto" width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_2689_2088)">
                    <path d="M26.311 28.8361L27.392 29.919L28.6556 31.1758L29.1418 31.6658L31.6652 29.1417L28.8367 26.3105L26.311 28.8361Z" fill="#5D6D7E"/>
                    <path d="M34.2371 29.1262L42.9403 37.8299C43.5948 38.4813 44.0014 39.388 43.9999 40.3848C43.9999 41.3836 43.5953 42.2902 42.9403 42.944C42.2878 43.5965 41.3834 44 40.3845 44C39.3862 44 38.4826 43.5961 37.8281 42.9409L29.1245 34.2382L34.2371 29.1262Z" fill="#F15540"/>
                    <path d="M33.0361 30.3288L33.7428 29.6201L42.4475 38.3249C42.9987 38.8752 43.3003 39.606 43.2998 40.3848C43.2998 41.1661 42.9977 41.899 42.4475 42.449C42.3485 42.5449 42.2205 42.5936 42.0931 42.5936C41.9644 42.5936 41.8362 42.5449 41.7383 42.4471C41.5436 42.2508 41.5436 41.9358 41.7383 41.7413C42.1006 41.38 42.3 40.896 42.3 40.3837C42.3004 39.8733 42.1017 39.3937 41.7399 39.0324L33.0361 30.3288Z" fill="#FFA184"/>
                    <path d="M29.1251 34.2384L34.2373 29.1262L33.8547 28.7436C33.6256 28.5126 33.3099 28.3718 32.9606 28.3718C32.6092 28.3718 32.2938 28.5124 32.0649 28.7406L28.7413 32.0672C28.5127 32.293 28.3706 32.6105 28.3706 32.9607C28.3706 33.3089 28.5127 33.6286 28.7413 33.8548L29.1251 34.2384Z" fill="#34495E"/>
                    <path d="M0 16.3419C0 7.31814 7.31684 0 16.342 0C25.3681 0 32.6845 7.31814 32.6838 16.3419C32.6843 25.3687 25.3671 32.6845 16.342 32.6873C7.31684 32.6845 0 25.3686 0 16.3419Z" fill="#34495E"/>
                    <path d="M16.3428 30.9169C24.3896 30.9169 30.9157 24.3914 30.9157 16.342C30.9157 8.29522 24.3896 1.76978 16.3428 1.76978C8.2956 1.76978 1.76904 8.29522 1.76904 16.342C1.76913 24.3916 8.29457 30.9169 16.3428 30.9169Z" fill="#5D6D7E"/>
                    <path d="M16.3425 29.7493C23.7451 29.7493 29.7489 23.7481 29.7489 16.3418C29.7489 8.94002 23.7451 2.93579 16.3425 2.93579C8.93921 2.93579 2.93652 8.94011 2.93652 16.3418C2.93652 23.7479 8.93843 29.7493 16.3425 29.7493Z" fill="#E6EAEE"/>
                    <path d="M16.6947 5.13586C16.4669 4.79796 16.0744 4.58629 15.643 4.61052C13.7919 4.72293 12.0436 5.24372 10.4448 6.17142C9.88227 6.50099 9.69002 7.22699 10.0165 7.7904C10.345 8.35012 11.0716 8.54872 11.6322 8.21631C12.9069 7.48085 14.302 7.06285 15.7819 6.97356C16.432 6.9397 16.9318 6.37827 16.8912 5.72927C16.8841 5.50419 16.8084 5.30241 16.6947 5.13586Z" fill="white"/>
                    <path d="M9.10452 9.0241C9.04247 8.92931 8.9604 8.84217 8.86956 8.76672C8.36158 8.35224 7.61779 8.43319 7.20683 8.93876C5.99923 10.4218 5.1683 12.2014 4.80203 14.0947C4.36822 16.3429 4.59475 18.6443 5.45696 20.755C5.70842 21.3628 6.39919 21.648 7.00247 21.3996C7.60834 21.1536 7.89588 20.4649 7.64795 19.8569C6.96071 18.1752 6.78221 16.3369 7.13121 14.543C7.41747 13.0318 8.08099 11.6115 9.04496 10.4297C9.37926 10.0185 9.38871 9.43987 9.10452 9.0241Z" fill="white"/>
                    </g>
                    <defs>
                    <clipPath id="clip0_2689_2088">
                    <rect width="44" height="44" fill="white"/>
                    </clipPath>
                    </defs>
                </svg>
                <p class="mt-6 text-color-14 font-Figtree text-20 font-medium text-center">{{ __('No history found')}}</p>
                <p class="font-Figtree mt-3 text-center text-color-89 font-medium">{{ __('Looks like you did not create any content yet.')}}</p>
                <a href="javascript:void(0)" class="px-6 py-[13px] border border-color-DF dark:border-[#474746] background-gradient-one rounded-xl text-15 font-semibold text-white mt-10 flex justify-center items-center w-max mx-auto">Let’s make history
                </a>
            </div>
            @endif
        </div>
        <!-- Partial history -->
        <div class="xl:w-[76%] 5xl:w-[71.3%] xl:px-0 px-5 bg-white dark:bg-[#292929] details-body 4xl:flex w-full pt-14 sidebar-scrollbar xl:h-screen xl:overflow-auto 4xl:overflow-hidden pb-0"
            id="partial-history">
        </div>
        <div class="loader-history h-full absolute left-[63%] top-[50%] dark:bg-color-29 hidden">
            <svg class="animate-spin h-12 w-12 m-auto" xmlns="http://www.w3.org/2000/svg" width="72"
                height="72" viewBox="0 0 72 72" fill="none">
                <mask id="path-1-inside-1_1032_3036" fill="white">
                    <path
                        d="M67 36C69.7614 36 72.0357 38.2493 71.6534 40.9841C70.685 47.9121 67.7119 54.4473 63.048 59.7573C57.2779 66.3265 49.3144 70.5713 40.644 71.6992C31.9736 72.8271 23.1891 70.761 15.9304 65.8866C8.67173 61.0123 3.4351 53.6628 1.19814 45.2104C-1.03881 36.7579 -0.123172 27.7803 3.77411 19.9534C7.67139 12.1266 14.2839 5.98568 22.3772 2.67706C30.4704 -0.631565 39.4912 -0.881694 47.7554 1.97337C54.4353 4.28114 60.2519 8.49021 64.5205 14.0322C66.2056 16.2199 65.3417 19.2997 62.9417 20.6656L60.8567 21.8524C58.4567 23.2183 55.4379 22.3325 53.5977 20.2735C50.9338 17.2927 47.5367 15.0161 43.7066 13.6929C38.2888 11.8211 32.3749 11.9851 27.0692 14.1542C21.7634 16.3232 17.4284 20.3491 14.8734 25.4802C12.3184 30.6113 11.7181 36.4969 13.1846 42.0381C14.6511 47.5794 18.0842 52.3975 22.8428 55.5931C27.6014 58.7886 33.3604 60.1431 39.0445 59.4037C44.7286 58.6642 49.9494 55.8814 53.7321 51.5748C56.4062 48.5302 58.2325 44.8712 59.0732 40.9628C59.6539 38.2632 61.8394 36 64.6008 36H67Z" />
                </mask>
                <path
                    d="M67 36C69.7614 36 72.0357 38.2493 71.6534 40.9841C70.685 47.9121 67.7119 54.4473 63.048 59.7573C57.2779 66.3265 49.3144 70.5713 40.644 71.6992C31.9736 72.8271 23.1891 70.761 15.9304 65.8866C8.67173 61.0123 3.4351 53.6628 1.19814 45.2104C-1.03881 36.7579 -0.123172 27.7803 3.77411 19.9534C7.67139 12.1266 14.2839 5.98568 22.3772 2.67706C30.4704 -0.631565 39.4912 -0.881694 47.7554 1.97337C54.4353 4.28114 60.2519 8.49021 64.5205 14.0322C66.2056 16.2199 65.3417 19.2997 62.9417 20.6656L60.8567 21.8524C58.4567 23.2183 55.4379 22.3325 53.5977 20.2735C50.9338 17.2927 47.5367 15.0161 43.7066 13.6929C38.2888 11.8211 32.3749 11.9851 27.0692 14.1542C21.7634 16.3232 17.4284 20.3491 14.8734 25.4802C12.3184 30.6113 11.7181 36.4969 13.1846 42.0381C14.6511 47.5794 18.0842 52.3975 22.8428 55.5931C27.6014 58.7886 33.3604 60.1431 39.0445 59.4037C44.7286 58.6642 49.9494 55.8814 53.7321 51.5748C56.4062 48.5302 58.2325 44.8712 59.0732 40.9628C59.6539 38.2632 61.8394 36 64.6008 36H67Z"
                    stroke="url(#paint0_linear_1032_3036)" stroke-width="24"
                    mask="url(#path-1-inside-1_1032_3036)" />
                <defs>
                    <linearGradient id="paint0_linear_1032_3036" x1="46.8123" y1="63.1382" x2="21.8195"
                        y2="6.73779" gradientUnits="userSpaceOnUse">
                        <stop offset="0" stop-color="#E60C84" />
                        <stop offset="1" stop-color="#FFCF4B" />
                    </linearGradient>
                </defs>
            </svg>
        </div>
    </div>
</div>
@endsection
