<?php

namespace Modules\OpenAI\Database\Seeders\versions\v6_6_0;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\OpenAI\AiProviders\OpenAi\Resources\TextToVideoDataProcessor;
use Modules\OpenAI\AiProviders\OpenAi\Resources\VideoDataProcessor;

class PreferenceTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('preferences')->upsert([
            [
                'category' => 'texttovideo',
                'field' => 'texttovideo_openai',
                'value' => json_encode((new TextToVideoDataProcessor())->textToVideoOptions()),
            ],
            [
                'category' => 'videomaker',
                'field' => 'videomaker_openai',
                'value' => json_encode((new VideoDataProcessor())->videoOptions()),
            ],
        ], ['field']);
    }
}

