<!-- Message Skeleton Loading State -->
<div class="p-5 h-[calc(100vh-184px)] overflow-y-auto space-y-6 skeleton-message-container">
    
    <!-- Bot Message Skeleton (Right side) -->
    <div class="ml-auto w-72">
        <div class="bg-gradient-to-r from-gray-100 to-gray-50 dark:from-gray-800 dark:to-gray-700 border border-gray-200 dark:border-gray-600 rounded-2xl p-5 animate-pulse">
            <div class="space-y-3">
                <!-- Header Skeleton -->
                <div class="h-4 bg-gray-300 dark:bg-gray-600 rounded w-3/4"></div>
                
                <!-- Body Lines Skeleton -->
                <div class="space-y-2">
                    <div class="h-3 bg-gray-300 dark:bg-gray-600 rounded w-full"></div>
                </div>
                
                <!-- Footer Skeleton -->
                <div class="mt-4 flex items-center justify-between">
                    <div class="h-6 bg-gray-300 dark:bg-gray-600 rounded-full w-20"></div>
                    <div class="h-4 bg-gray-300 dark:bg-gray-600 rounded w-16"></div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- User Message Skeleton (Left side) -->
    <div class="flex items-start gap-4">
        <!-- Avatar Skeleton -->
        <div class="shrink-0 w-12 h-12 bg-gray-300 dark:bg-gray-600 rounded-full animate-pulse"></div>
        
        <!-- Message Content Skeleton -->
        <div class="bg-gray-100 dark:bg-gray-700 rounded-2xl rounded-tl-md px-6 py-4 max-w-xs border border-gray-200 dark:border-gray-600 animate-pulse">
            <div class="space-y-2">
                <div class="h-3 bg-gray-300 dark:bg-gray-600 rounded w-full"></div>
            </div>
        </div>
    </div>
    
    <!-- Bot Message with Image Skeleton -->
    <div class="ml-auto w-72">
        <div class="bg-gradient-to-r from-gray-100 to-gray-50 dark:from-gray-800 dark:to-gray-700 border border-gray-200 dark:border-gray-600 rounded-2xl p-5 animate-pulse">
            <div class="space-y-3">
                <!-- Image Skeleton -->
                <div class="w-full h-40 bg-gray-300 dark:bg-gray-600 rounded-lg"></div>
                
                <!-- Title Skeleton -->
                <div class="h-4 bg-gray-300 dark:bg-gray-600 rounded w-2/3"></div>
                
                <!-- Body Lines Skeleton -->
                <div class="space-y-2">
                    <div class="h-3 bg-gray-300 dark:bg-gray-600 rounded w-full"></div>
                    <div class="h-3 bg-gray-300 dark:bg-gray-600 rounded w-5/6"></div>
                </div>
                
                <!-- Buttons Skeleton -->
                <div class="space-y-2">
                    <div class="h-10 bg-gray-300 dark:bg-gray-600 rounded-lg"></div>
                    <div class="h-10 bg-gray-300 dark:bg-gray-600 rounded-lg"></div>
                </div>
                
                <!-- Footer Skeleton -->
                <div class="mt-4 flex items-center justify-between">
                    <div class="h-6 bg-gray-300 dark:bg-gray-600 rounded-full w-20"></div>
                    <div class="h-4 bg-gray-300 dark:bg-gray-600 rounded w-16"></div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- User Message Skeleton -->
    <div class="flex items-start gap-4">
        <div class="shrink-0 w-12 h-12 bg-gray-300 dark:bg-gray-600 rounded-full animate-pulse"></div>
        <div class="bg-gray-100 dark:bg-gray-700 rounded-2xl rounded-tl-md px-6 py-4 max-w-xs border border-gray-200 dark:border-gray-600 animate-pulse">
            <div class="space-y-2">
                <div class="h-3 bg-gray-300 dark:bg-gray-600 rounded w-full"></div>
            </div>
        </div>
    </div>
    
</div>