"use strict";$(document).ready((function(){let $contactsDropdown,$contactsContainer,$contactsSearch,$contactsLoader,$contactsButton,$contactsHiddenInput,$contactsDisplay,selectedContacts=[],searchTimeout,isLoading=!1,currentXhr=null,currentPage=1,hasMorePages=!0,baseUrl="";function init(){$contactsDropdown=$("#contacts-dropdown"),$contactsContainer=$("#contacts-container"),$contactsSearch=$("#contacts-search"),$contactsLoader=$("#contacts-loader"),$contactsButton=$("#contacts-button"),$contactsHiddenInput=$("#contacts-hidden-input"),$contactsDisplay=$("#contacts-display"),0!==$contactsDropdown.length&&0!==$contactsContainer.length&&(baseUrl=$contactsDropdown.attr("data-base-url")||'{{ route("user.marketing-bot.contacts.dropdown") }}',loadContacts(!0),setupEventListeners())}function setupEventListeners(){$contactsDropdown.on("click",(function(e){e.stopPropagation()})),$contactsSearch.on("click",(function(e){e.stopPropagation()})),$contactsContainer.on("click",(function(e){e.stopPropagation()})),$contactsDropdown.on("click","*",(function(e){e.stopPropagation()})),$contactsSearch.on("input",(function(e){clearTimeout(searchTimeout);const searchTerm=$(this).val().trim();$contactsLoader.length>0&&(searchTerm?$contactsLoader.removeClass("hidden"):$contactsLoader.addClass("hidden")),searchTimeout=setTimeout((function(){loadContacts(!0,searchTerm)}),300)})),$contactsContainer.on("scroll",(function(){if(isLoading||!hasMorePages)return;const $this=$(this),scrollTop=$this.scrollTop(),scrollHeight=$this[0].scrollHeight,clientHeight=$this.height();scrollTop+clientHeight>=.8*scrollHeight&&loadContacts(!1)}))}function loadContacts(reset=!1,searchTerm=""){if(isLoading)return;currentXhr&&4!==currentXhr.readyState&&(currentXhr.abort(),currentXhr=null),isLoading=!0,reset&&(currentPage=1,hasMorePages=!0);let url=baseUrl;const params=new URLSearchParams;params.append("page",currentPage),searchTerm&&params.append("search",searchTerm),params.toString()&&(url+="?"+params.toString()),currentXhr=$.ajax({url:url,type:"GET",dataType:"json",headers:{"X-Requested-With":"XMLHttpRequest"},beforeSend:function(xhr){currentXhr=xhr},success:function(data){if(!currentXhr||"abort"!==currentXhr.statusText)if(data.success&&data.contacts){if(reset&&$contactsContainer.html(""),0===data.contacts.length&&reset)return $contactsContainer.html(`\n                            <div class="px-4 py-8 text-center">\n                                <svg class="mx-auto h-12 w-12 text-color-89 dark:text-gray-500 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">\n                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>\n                                </svg>\n                                <p class="text-sm text-color-89 dark:text-gray-400">${jsLang("No contacts found")}</p>\n                                <p class="text-xs text-color-89 dark:text-gray-500 mt-1">${jsLang("Try adjusting your search terms")}</p>\n                            </div>\n                        `),currentPage=data.current_page,void(hasMorePages=data.has_more_pages);data.contacts.forEach((function(contact){const isSelected=selectedContacts.includes(contact.id),contactName=contact.name||contact.phone||`Contact ${contact.id}`,$contactItem=$(`\n                            <div class="px-4 py-2.5 rounded-lg text-sm text-gray-700 dark:text-gray-200 hover:bg-color-F6 dark:hover:bg-color-3A cursor-pointer flex items-center gap-3 transition-colors duration-150"\n                                data-id="${contact.id}"\n                                data-name="${escapeHtml(contactName)}">\n                                <div class="relative flex items-center">\n                                    <input type="checkbox"\n                                           class="contact-checkbox w-4 h-4 rounded border-color-DF dark:border-color-47 text-blue-600 focus:ring-2 focus:ring-blue-500 dark:focus:ring-blue-400 focus:ring-offset-0 cursor-pointer transition-all duration-150"\n                                           value="${contact.id}"\n                                           ${isSelected?"checked":""}>\n                                </div>\n                                <span class="flex-1 font-medium">${escapeHtml(contactName)}</span>\n                            </div>\n                        `),$checkbox=$contactItem.find(".contact-checkbox");$checkbox.on("change",(function(){const contactId=$(this).val(),contactName=$(this).closest("[data-name]").attr("data-name");if($(this).is(":checked"))selectedContacts.includes(contactId)||selectedContacts.push(contactId);else{const index=selectedContacts.indexOf(contactId);index>-1&&selectedContacts.splice(index,1)}updateSelectedDisplay()})),$checkbox.on("click",(function(e){e.stopPropagation()})),$contactItem.on("click",(function(e){if($(e.target).is('input[type="checkbox"]'))return;e.preventDefault(),e.stopPropagation();const isChecked=$checkbox.is(":checked");$checkbox.prop("checked",!isChecked).trigger("change")})),$contactsContainer.append($contactItem)})),currentPage=data.current_page,hasMorePages=data.has_more_pages}else reset&&$contactsContainer.html(`\n                            <div class="px-4 py-8 text-center">\n                                <p class="text-sm text-red-500">${jsLang("Failed to load contacts")}</p>\n                            </div>\n                        `)},error:function(xhr,status,error){"abort"!==status&&(console.error("Error loading contacts:",error),reset&&$contactsContainer.html('\n                        <div class="px-4 py-8 text-center">\n                            <p class="text-sm text-red-500">Failed to load contacts</p>\n                        </div>\n                    '))},complete:function(){isLoading=!1,currentXhr=null,$contactsLoader.length>0&&$contactsLoader.addClass("hidden")}})}function updateSelectedDisplay(){if($contactsHiddenInput.length>0&&$contactsHiddenInput.val(selectedContacts.join(",")),$contactsDisplay.length>0)if(0===selectedContacts.length)$contactsDisplay.text(jsLang("Select Contact List"));else if(1===selectedContacts.length){const $selectedItem=$contactsContainer.find(`[data-id="${selectedContacts[0]}"]`),contactName=$selectedItem.attr("data-name")||jsLang("Contact");$contactsDisplay.text(contactName)}else $contactsDisplay.text(`${selectedContacts.length} ${jsLang("contacts selected")}`)}function escapeHtml(unsafe){if(null==unsafe)return"";const str=String(unsafe);return str.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")}init()}));