<?php

use Illuminate\Support\Facades\Route;
use Modules\MenuBuilder\Http\Models\MenuItems;
use Modules\MenuBuilder\Http\Models\Menus;

if (!function_exists('is_active_database_backup_sidebar')) {
    
    function is_active_database_backup_sidebar(string $routeName) : bool
    {
        return Route::currentRouteName() === $routeName;
    }
}

add_action("before_databasebackup_addon_deactivation", function() {
    $menu = MenuItems::where('label', 'Tools')->first();
    MenuItems::where('parent', $menu->id)->count() === 1 ? MenuItems::where('label', 'Tools')->delete() : null;
    Menus::whereIn('slug', ['manual-backup', 'automated-backup'])->delete();
    MenuItems::where('link', 'manual-backup-list')->delete();
});
